#-----------------------------------------------------------------------------
# Tiler
# 1/27/04
# Copyright (c) 2004 David G. Drumright (ockham)
# Set up the mesh, select the "tile" object, and activate the script.
# The script will place one "tile" at each vertex of the mesh.  You can
# then adjust the scale, rotation, and translation of all "tiles" together,
# until it looks right.  The tiles are all parented to the mesh, so you
# can save the whole thing as a prop or figure.
#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
import poser
import math
import string
import os
scene = poser.Scene()
BasePathUncut=poser.AppLocation()
BasePath=BasePathUncut[:(-len('poser.exe'))]
#MyPath=os.path.normpath(BasePath+'/Runtime/Libraries/props/*.PP2')
MyPath=os.path.normpath(BasePath+'/Runtime/Libraries/props/*.CR2')
NullPropPath=os.path.normpath(BasePath+'/Runtime/Libraries/props/Tiler/NULL.PP2')

R2D = 180.0 / math.pi
D2R = math.pi / 180.0

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Tiler")

        self.StatusEntry = Entry(self.master,width=40)
        self.StatusEntry.grid(row=0,column=1)
        self.StatusEntry.insert(0,"Hit Populate to select the 'tile' prop.")

        # Set up the Base first.
        # The base must be the selected item.
        self.BaseItem = scene.CurrentActor()
        if (not self.BaseItem) or (self.BaseItem.IsDeformer()):
            self.ShowStatus("Base mesh not present or improper.  Cancel and restart.")

        # Go/nogo buttons.
        self.buttonPopulate = Button(self.master, text="Populate", command=self.handlePopulate)
        self.buttonPopulate.grid(row=3, column=0)

        self.buttonAdjust = Button(self.master, text="Adjust", command=self.handleAdjust)
        self.buttonAdjust.grid(row=3, column=1)

        self.buttonCancel = Button(self.master, text="Close", command=self.HandleCancel)
        self.buttonCancel.grid(row=3, column=2)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)

        self.TileList={} # Dict: key is name, value is tuple of parms

    # - - - - - - - - - - - - - - - - - -
    def ShowStatus(self,S): # Just saving repetition
        self.StatusEntry.delete(0,END)
        self.StatusEntry.insert(0,S)
        self.StatusEntry.update_idletasks()

    # - - - - - - - - - - - - - - - - - -

    def PolyNorm(self,PList):
        # Takes a list holding first three points of polygon as tuples, gives normal of poly
        # in degrees.
        if len(PList) < 3: raise "Problem in PolyNorm"
        (P0x,P0y,P0z)=PList[0]
        (P1x,P1y,P1z)=PList[1]
        (P2x,P2y,P2z)=PList[2]

        A = (P2y - P0y)*(P1z - P0z) - (P1y - P0y)*(P2z - P0z)
        B = (P1x - P0x)*(P2z - P0z) - (P2x - P0x)*(P1z - P0z)
        C = (P2x - P0x)*(P1y - P0y) - (P1x - P0x)*(P2y - P0y)
        Dist= math.sqrt(A*A+B*B+C*C)
        if Dist == 0.0:
            return (0.0,0.0,0.0)
        else:
            Ax = R2D * math.acos(A/Dist)
            By = R2D * math.acos(-B/Dist)
            Cz = R2D * math.acos(C/Dist)
            return (Ax,By,Cz)

    # - - - - - - - - - - - - - - - - - -

    def handlePopulate(self):

        # Bring in the Null Prop.
        scene.LoadLibraryProp(os.path.normpath(NullPropPath))
        NullProp=scene.CurrentActor()

        BaseGeom = self.BaseItem.Geometry()
        SetList = BaseGeom.Sets()

        # Pop up file box to get a Tile.
        fn=tkFileDialog.askopenfilename(initialfile=MyPath, filetypes=[("Props", "PP2")] )
        if not fn:
            self.ShowStatus("No file selected. Try again.")
            return

        self.ShowStatus("Working.......")

        # For each facet of the base, repeat the Tile and place it at the center of the facet,
        # oriented by the normals of the polygons.
        scene.DrawAll() # Get the WVs right
        # Run a loop by Polygons.
        for FacetIndex in range(BaseGeom.NumPolygons()):
            OneFacet = BaseGeom.Polygon(FacetIndex)
            First = OneFacet.Start()
            Last = First + OneFacet.NumVertices()
            PolyNormList=[]
            PolyNormCount=0
            SumX=0.0
            SumY=0.0
            SumZ=0.0
            SumCount=0.0
            for Vindex in SetList[First:Last]: # This is a list of vertex indexes in the poly
                # Get the values:
                OneVert = BaseGeom.WorldVertex(Vindex)
                X = OneVert.X()
                Y = OneVert.Y()
                Z = OneVert.Z()
                # Pick up the first three verts for the PolyNorm method,
                # and sum all for the center point.
                if PolyNormCount < 3: # Cut the list at 3
                    PolyNormList.append( (X,Y,Z) )
                    PolyNormCount=PolyNormCount+1
                SumX=SumX+X
                SumY=SumY+Y
                SumZ=SumZ+Z
                SumCount=SumCount+1.0
            # Now form the normal and the center point.
            if SumCount == 0.0: raise "Bad sum, line 118"

            (NormX,NormY,NormZ) = self.PolyNorm(PolyNormList)
            CenterX = SumX / SumCount
            CenterY = SumY / SumCount
            CenterZ = SumZ / SumCount

            # Create a copy of the Tile.
            try:
                scene.LoadLibraryProp(os.path.normpath(fn))
            except:
                self.ShowStatus("Prop not usable. Try again.")
                return
            # The new prop will be currentactor at this moment.
            Tile = scene.CurrentActor()

            # For convenience, get the necessary parms of all piecees:
            BaseXrot = self.BaseItem.ParameterByCode(poser.kParmCodeXROT)
            BaseYrot = self.BaseItem.ParameterByCode(poser.kParmCodeYROT)
            BaseZrot = self.BaseItem.ParameterByCode(poser.kParmCodeZROT)
            NullXrot  =     NullProp.ParameterByCode(poser.kParmCodeXROT)
            NullYrot  =     NullProp.ParameterByCode(poser.kParmCodeYROT)
            NullZrot  =     NullProp.ParameterByCode(poser.kParmCodeZROT)
            TileXrot =          Tile.ParameterByCode(poser.kParmCodeXROT)
            TileYrot =          Tile.ParameterByCode(poser.kParmCodeYROT)
            TileZrot =          Tile.ParameterByCode(poser.kParmCodeZROT)
            TileXtran =         Tile.ParameterByCode(poser.kParmCodeXTRAN)
            TileYtran =         Tile.ParameterByCode(poser.kParmCodeYTRAN)
            TileZtran =         Tile.ParameterByCode(poser.kParmCodeZTRAN)
            TileXscale =        Tile.ParameterByCode(poser.kParmCodeXSCALE)
            TileYscale =        Tile.ParameterByCode(poser.kParmCodeYSCALE)
            TileZscale =        Tile.ParameterByCode(poser.kParmCodeZSCALE)
            TileAscale =        Tile.ParameterByCode(poser.kParmCodeASCALE)

            # ****** This setup is now just about right. The Xrot is not
            # the proper value.

            # The NormX goes to the Yrot of the Null first,
            # and then NormY goes to the Xrot of the Tile
            # after parenting.  This is the simplest way to
            # get around the gimbal-lock problem.
            Yrot = NormX + 90.0
            #Xrot = NormY - 90.0
            Xrot = NormY

            TileYrot.SetValue(Yrot)
            Tile.SetParent(NullProp,0,0)
            scene.DrawAll()
            TileXrot.SetValue(Xrot)

            # Deparent from the Null
            Tile.SetParent(scene.Actor("UNIVERSE"),0,0)

            # Put the tile, still angled from the Null stuff,
            # onto the mesh at the proper point
            TileXtran.SetValue(CenterX)
            TileYtran.SetValue(CenterY)
            TileZtran.SetValue(CenterZ)

            # Now re-parent the tile to the mesh.
            Tile.SetParent(self.BaseItem)

            # We don't change the scale at this point, but we pick it up for the adjust array.
            # We also get the rotations again, because parenting changed them.
            Xscale = TileXscale.Value()
            Yscale = TileYscale.Value()
            Zscale = TileZscale.Value()
            Ascale = TileAscale.Value()
            Xrot = TileXrot.Value()
            Yrot = TileYrot.Value()
            Zrot = TileZrot.Value()
            # Place the new name and its location in the list
            self.TileList[Tile.Name()] = (CenterX,CenterY,CenterZ,Xrot,Yrot,Zrot,Xscale,Yscale,Zscale,Ascale)

        scene.DrawAll()
        self.ShowStatus("Now select one, adjust it, then hit Adjust.")


    # - - - - - - - - - - - - - - - - - -

    def handleAdjust(self):
        # Take the selected Tile and apply its CHANGE in position to all others.
        PrimeTile = scene.CurrentActor()
        if PrimeTile.Name() not in self.TileList.keys():
            self.ShowStatus("Selected actor is not one of tiles")
            return
        # Get the original parms from the list:
        (Xtran,Ytran,Ztran,Xrot,Yrot,Zrot,Xscale,Yscale,Zscale,Scale) = self.TileList[PrimeTile.Name()]
        # Find deltas from new actual settings.
        NewXtran  = PrimeTile.Parameter("xTran").Value()
        NewYtran  = PrimeTile.Parameter("yTran").Value()
        NewZtran  = PrimeTile.Parameter("zTran").Value()
        NewXrot   = PrimeTile.Parameter("xRotate").Value()
        NewYrot   = PrimeTile.Parameter("yRotate").Value()
        NewZrot   = PrimeTile.Parameter("zRotate").Value()
        NewXscale = PrimeTile.Parameter("xScale").Value()
        NewYscale = PrimeTile.Parameter("yScale").Value()
        NewZscale = PrimeTile.Parameter("zScale").Value()
        NewScale  = PrimeTile.Parameter("Scale").Value()

        DeltaXtran  = NewXtran - Xtran
        DeltaYtran  = NewYtran - Ytran
        DeltaZtran  = NewZtran - Ztran
        DeltaXrot   = NewXrot - Xrot
        DeltaYrot   = NewYrot - Yrot
        DeltaZrot   = NewZrot - Zrot
        DeltaXscale = NewXscale - Xscale
        DeltaYscale = NewYscale - Yscale
        DeltaZscale = NewZscale - Zscale
        DeltaScale  = NewScale  - Scale
        # Replace the values of the Prime.
        self.TileList[PrimeTile.Name()] =(NewXtran, NewYtran, NewZtran, NewXrot, NewYrot, NewZrot, NewXscale,NewYscale, NewZscale, NewScale)

        for OneSibName in self.TileList.keys():
            if OneSibName != PrimeTile.Name():
                OneSib = scene.Actor(OneSibName)

                P=OneSib.Parameter("xTran")
                NewXtran=P.Value()+DeltaXtran
                P.SetValue(NewXtran)
                P=OneSib.Parameter("yTran")
                NewYtran=P.Value()+DeltaYtran
                P.SetValue(NewYtran)
                P=OneSib.Parameter("zTran")
                NewZtran=P.Value()+DeltaZtran
                P.SetValue(NewZtran)

                P=OneSib.Parameter("xRotate")
                NewXrot=P.Value()+DeltaXrot
                P.SetValue(NewXrot)
                P=OneSib.Parameter("yRotate")
                NewYrot=P.Value()+DeltaYrot
                P.SetValue(NewYrot)
                P=OneSib.Parameter("zRotate")
                NewZrot=P.Value()+DeltaZrot
                P.SetValue(NewZrot)

                P=OneSib.Parameter("xScale")
                NewXscale=P.Value()+DeltaXscale
                P.SetValue(NewXscale)
                P=OneSib.Parameter("yScale")
                NewYscale=P.Value()+DeltaYscale
                P.SetValue(NewYscale)
                P=OneSib.Parameter("zScale")
                NewZscale=P.Value()+DeltaZscale
                P.SetValue(NewZscale)
                P=OneSib.Parameter("Scale")
                NewScale=P.Value()+DeltaScale
                P.SetValue(NewScale)

                # Finally Replace the values with new
                self.TileList[OneSibName] =(NewXtran, NewYtran, NewZtran, NewXrot, NewYrot, NewZrot, NewXscale,NewYscale, NewZscale, NewScale)


        scene.DrawAll()
        self.ShowStatus("Adjust again, or Close.")

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents(1)
        root.lift()
        root.after(250, self.Update)

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
