#-----------------------------------------------------------------------------
# Anaglyph
# 2/10/05
# Copyright (c) 2005 by David G. Drumright (ockham)

#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
root = Tk()
import poser
import os
import sys
import string
scene = poser.Scene()

BasePathUncut = poser.AppLocation()  # So we can strip off the full paths given by tkFileDialog
BasePath = BasePathUncut[:(-len('poser.exe'))]

ScriptLocation = os.path.abspath(os.path.join(BasePath,'runtime/Python/poserScripts/Anaglyph'))

# Put BMPs in folder under script path
BMPLocation=os.path.join(ScriptLocation,'Outputs')
# If dir already made, ignore error.
try:
    os.mkdir(BMPLocation)
except:
    pass

# Get path for the AVI-maker.  Don't check this until the RenderAVI
# button is hit.
BMP2AVIpath=os.path.normpath(os.path.join(BMPLocation,'BMP2AVI.EXE' ))

RedName=os.path.normpath(os.path.join(BMPLocation,"Red.BMP"))
GrnName=os.path.normpath(os.path.join(BMPLocation,"Grn.BMP"))

WINSIZE=400

#-----------------------------------------------------------------------------

# Get the PYD
if float(poser.Version()) < 5.0:
    import _Anaglyphmodule15
    import _Anaglyphmodule15
    Mix = _Anaglyphmodule15.Mix
    ShowBMP = _Anaglyphmodule15.ShowBMP
else:
    import _Anaglyphmodule22
    Mix = _Anaglyphmodule22.Mix
    ShowBMP = _Anaglyphmodule22.ShowBMP

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Anaglyph")
        self.IgnoreVar=IntVar()
        self.IgnoreVar.set(0)

        self.TopFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.TopFrame.grid(row=0,column=0)

        self.PicFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.PicFrame.grid(row=1,column=0)

        self.ButFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ButFrame.grid(row=2,column=0)

        Label(self.TopFrame,text="R limit").grid(row=0,column=0)
        self.LimRSlider = Scale(self.TopFrame,from_=0,to=255,orient=HORIZONTAL)
        self.LimRSlider.grid(row=0,column=1)
        self.LimRSlider.set(30)

        Label(self.TopFrame,text="G limit").grid(row=0,column=2)
        self.LimGSlider = Scale(self.TopFrame,from_=0,to=255,orient=HORIZONTAL)
        self.LimGSlider.grid(row=0,column=3)
        self.LimGSlider.set(15)

        Label(self.TopFrame,text="B limit").grid(row=0,column=4)
        self.LimBSlider = Scale(self.TopFrame,from_=0,to=255,orient=HORIZONTAL)
        self.LimBSlider.grid(row=0,column=5)
        self.LimBSlider.set(15)

        self.IgnoreCheck=Checkbutton(self.TopFrame,text="Ignore black")
        self.IgnoreCheck.grid(row=0,column=6)

        self.Pic = Canvas(self.PicFrame,  width=WINSIZE,height=WINSIZE,bg="white",borderwidth=2,relief=RIDGE)
        self.Pic.grid(row=1,column=0)
        self.Pic.bind("<Button-1>", self.HandlePicClick)

        self.buttonPreview = Button(self.ButFrame, text="Preview", bg="green",command=self.HandlePreview)
        self.buttonPreview.grid(row=0, column=0, padx=10)

        self.buttonRender = Button(self.ButFrame, text="Render", bg="yellow", command=self.HandleRender)
        self.buttonRender.grid(row=0, column=1, padx=10)

        self.buttonAnimate = Button(self.ButFrame, text="Animate", bg="red",command=self.HandleAnimate)
        self.buttonAnimate.grid(row=0, column=2, padx=10)

        self.buttonLeftCoarse = Button(self.ButFrame, text="<<", command=self.HandleLeftCoarse)
        self.buttonLeftCoarse.grid(row=0, column=3, padx=2)
        self.buttonLeftFine = Button(self.ButFrame, text="<", command=self.HandleLeftFine)
        self.buttonLeftFine.grid(row=0, column=4, padx=2)

        self.Show = Entry(self.ButFrame, width=8)
        self.Show.grid(row=0, column=5, padx=2)
        self.Show.bind("<Return>",self.HandleEntry)

        self.buttonLeftFine = Button(self.ButFrame, text=">", command=self.HandleRightFine)
        self.buttonLeftFine.grid(row=0, column=6, padx=2)
        self.buttonLeftCoarse = Button(self.ButFrame, text=">>", command=self.HandleRightCoarse)
        self.buttonLeftCoarse.grid(row=0, column=7, padx=2)

        self.buttonCancel = Button(self.ButFrame, text="Cancel", command=self.HandleCancel)
        self.buttonCancel.grid(row=0, column=8, padx=10)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)

        # Make Aux cam equal Main cam:
        MCam=scene.Actor("Main Camera")
        ACam=scene.Actor("Aux Camera")
        for MP in MCam.Parameters():
            AP=ACam.Parameter(MP.Name())
            AP.SetValue(MP.Value())

        scene.SetRenderToNewWindow(0) # Be sure we render to the preview window

        self.Action(0)  # Show once

    # - - - - - - - - - - - - - - - - - -

    def HandlePicClick(self, val):
        os.system('start Runtime\Python\poserScripts\Anaglyph\Outputs\Out.BMP')

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents()
        root.lift()
        root.after(100, self.Update)

    # - - - - - - - - - - - - - - - - - -

    def HandleLeftFine(self):
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(P.Value()-0.1)
        self.Action(0)

    # - - - - - - - - - - - - - - - - - -

    def HandleLeftCoarse(self):
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(P.Value()-1.0)
        self.Action(0)

    # - - - - - - - - - - - - - - - - - -

    def HandleRightFine(self):
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(P.Value()+0.1)
        self.Action(0)

    # - - - - - - - - - - - - - - - - - -

    def HandleRightCoarse(self):
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(P.Value()+1.0)
        self.Action(0)

    # - - - - - - - - - - - - - - - - - -

    def HandleEntry(self,event):
        st=event.widget.get()
        if not st: return
        else:      Val=float(st)
        Cam=scene.Actor("Aux Camera")
        P=Cam.ParameterByCode(poser.kParmCodeYROT)
        P.SetValue(Val)
        self.Action(0)

    # - - - - - - - - - - - - - - - - - -

    def HandleAnimate(self):
        # Get vals
        IgnoreBlack=self.IgnoreVar.get()
        RedLim=self.LimRSlider.get()
        GrnLim=self.LimGSlider.get()
        BluLim=self.LimBSlider.get()

        #if not os.path.exists(BMP2AVIpath):
        #    self.ShowStatus('BMP2AVI.EXE is not installed.')
        #    return

        for F in range(scene.NumFrames()):

            scene.SetFrame(F)

            self.Show.delete(0,END)
            self.Show.insert(0,"%d/%d" % (F+1,NumF))
            self.Show.update_idletasks()

            MCam=scene.Actor("Main Camera")
            ACam=scene.Actor("Aux Camera")

            scene.SetCurrentCamera(MCam)
            scene.Render()
            scene.SaveImage("bmp",RedName)

            scene.SetCurrentCamera(ACam)
            scene.Render()
            scene.SaveImage("bmp",GrnName)

            # Next comes the mixing
            ImageName="Image_%.4d.BMP" % (F+1)
            OutName=os.path.normpath(os.path.join(BMPLocation,ImageName))
            Mix(RedName,GrnName,OutName,IgnoreBlack,RedLim,GrnLim,BluLim)

        # If we reach this point, make the AVI
        #OutName=os.path.normpath(os.path.join(BMPLocation,'3d'))
        #if scene.Sound():
        #    CommandLine = 'BMP2AVI -i Image_ -o %s -f %d -w %s' % (OutName,scene.FramesPerSecond(),scene.Sound())
        #else:
        #    CommandLine = 'BMP2AVI -i Image_ -o %s -f %d'       % (OutName,scene.FramesPerSecond() )
        #
        #os.chdir(BMPLocation)
        #os.system(CommandLine) # Run BMP2AVI

        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def HandlePreview(self):
        self.Action(0)

    # - - - - - - - - - - - - - - - - - -
    def HandleRender(self):
        self.Action(1)
    # - - - - - - - - - - - - - - - - - -
    def HandleCancel(self):
        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -


    def Action(self,Render):
        # Get vals
        IgnoreBlack=self.IgnoreVar.get()
        RedLim=self.LimRSlider.get()
        GrnLim=self.LimGSlider.get()
        BluLim=self.LimBSlider.get()
        # Show the cam angle
        MCam=scene.Actor("Main Camera")
        MP=MCam.ParameterByCode(poser.kParmCodeYROT)
        ACam=scene.Actor("Aux Camera")
        AP=ACam.ParameterByCode(poser.kParmCodeYROT)
        self.Show.delete(0,END)
        self.Show.insert(0,str(AP.Value()))

        scene.SetCurrentCamera(MCam)
        if Render: scene.Render()
        else:      scene.DrawAll()
        scene.SaveImage("bmp",RedName)

        scene.SetCurrentCamera(ACam)
        if Render: scene.Render()
        else:      scene.DrawAll()
        scene.SaveImage("bmp",GrnName)

        # Next comes the mixing
        OutName=os.path.normpath(os.path.join(BMPLocation,"Out.BMP"))
        Mix(RedName,GrnName,OutName,IgnoreBlack,RedLim,GrnLim,BluLim)
        TKHwnd = self.Pic.winfo_id()
        ShowBMP(TKHwnd,OutName,0,0,WINSIZE,WINSIZE)

    # - - - - - - - - - - - - - - - - - -

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
