#-----------------------------------------------------------------------------
# 8/29/06
# Internal utility, to strip out the unnecessary stuff in a CR2.
#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
import poser
import os
import string

Unwanteds=['jointX', 'jointY','jointZ',
           'twistX','twistY','twistZ',
           'smoothScaleX','smoothScaleY','smoothScaleZ',
           'taperX','taperY','taperZ',
           'controlProp'  ] # P6 stuff
           #'shaderTree','controlProp'  ] # P6 stuff

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Pick a CR2 to furniturize")

        self.StatusEntry = Entry(self.master,width=30)
        self.StatusEntry.grid(row=0,column=0)

        # Go/nogo buttons.
        self.buttonGo = Button(self.master, text="Find file", command=self.HandleGo)
        self.buttonGo.grid(row=3, column=0)

        self.buttonCancel = Button(self.master, text="Cancel", command=self.HandleCancel)
        self.buttonCancel.grid(row=3, column=2)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)


    # - - - - - - - - - - - - - - - - - -

    def ShowStatus(self,S): # Just saving repetition
        self.StatusEntry.delete(0,END)
        self.StatusEntry.insert(0,S)
        self.StatusEntry.update_idletasks()

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        #if scene: scene.ProcessSomeEvents(1)
        root.lift()
        root.after(100, self.Update)

    # - - - - - - - - - - - - - - - - - -

    def HandleName(self):
        # Pop up file box to get name.
        BasePathUncut=poser.AppLocation()
        BasePath=BasePathUncut[:(-len('poser.exe'))]
        MyPath=os.path.normpath(BasePath+'/runtime/libraries/character/*.CR2')
        fn=tkFileDialog.askopenfilename(initialfile=MyPath, defaultextension=[("CR2 file", "*.CR2 *.cr2")] )

        if not fn:
            self.ShowStatus("No file selected. Try again.")
            return 0

        return os.path.abspath(fn)

    # - - - - - - - - - - - - - - - - - -

    def Convert(self,Name):
        self.ShowStatus("working on %s" % Name)
        fpIn=open(Name,'rt')
        front,ext=os.path.splitext(Name)
        OutName=front+"OUT.CR2"
        fpOut=open(OutName,'wt')

        # Run through and locate the unneeded sections by name.
        # When we encounter one, skip over it.
        Skip=0
        Brackets=0
        while 1:
            st=fpIn.readline()
            if not st: break
            parts=string.split(string.strip(st))
            if len(parts)>1:
                if parts[0] in Unwanteds:
                    Skip=1
            if not Skip:
                if (len(parts)>1) and (parts[0] == 'bend'):
                    fpOut.write('    bend 0\n')
                else:
                    fpOut.write(st)
            if Skip: # count brackets
                if string.count(st,'{'):
                    Brackets=Brackets+1
                if string.count(st,'}'):
                    Brackets=Brackets-1
                    if Brackets <= 0:
                         Skip=0
        fpIn.close()
        fpOut.close()
        self.ShowStatus("Done with %s." % OutName)

    # - - - - - - - - - - - - - - - - - -

    def HandleGo(self):
        # Action here
        Name=self.HandleName()
        if Name:
            self.Convert(Name)
        #self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------


