#-----------------------------------------------------------------------------
# for each frame play the MTS on the dynamic prop.
# by ockham 11/4/09

# Assume the starting frame is the real zero.
#-----------------------------------------------------------------------------
import poser
import string
import os

scene=poser.Scene()
OneActor=scene.CurrentActor()
scene.SetFrame(0)

#-----------------------------------------------------------------------------
def FakeFrames(DesiredCount):
	# Write a short PZ2 file forcing the desired number of
	# frames; load it; delete it.
	BasePathUncut=poser.AppLocation()
	BasePath=BasePathUncut[:(-len('poser.exe'))]
	DirName=os.path.join(BasePath,'runtime','libraries','pose','fakes')
	try:
		os.mkdir(DirName)
	except:
		pass # ignore 'already exists"
	PZ2Name=os.path.join(DirName,'ztemp.pz2')
	fpFake=open(PZ2Name,'wt')
	if not fpFake: return 0
	fpFake.write('{\nversion\n\t{\n\tnumber 4.2\n\t}\nmovieInfo\n\t{\n\t')
	fpFake.write('numFrames %d\n\t}\n}' % DesiredCount)
	fpFake.close()
	try:
		scene.LoadLibraryPose(PZ2Name)
	except:
		return 0
	os.remove(PZ2Name)
	return 1

#-----------------------------------------------------------------------------

# First locate all the MTs and set them all to zero at all frames.
AllDMTs=[]
for P in OneActor.Parameters():
	if not P.IsMorphTarget(): continue
	N=P.Name()
	if not string.count(N,'DMT'): continue
	AllDMTs.append(N)

# Get the count and add enough frames
NeededFrames=len(AllDMTs)
if scene.NumFrames() < NeededFrames:
	FakeFrames(NeededFrames+1)


for f in range(scene.NumFrames()):
	print "setting frame %d" % f
	for N in AllDMTs:
		P=OneActor.Parameter(N)
		parts=string.split(N,'_')
		number=int(parts[1])
		if number==f:
			P.SetValue(1.0)
		else:
			P.SetValue(0.0)
	scene.DrawAll()
# end loop on frames

# That should do it.
print "Done."

#-----------------------------------------------------------------------------
