#-----------------------------------------------------------------------------
# for each frame spawn a MT on the dynamic prop.
# by ockham 11/4/09

# Assume the starting frame is the real zero.
#-----------------------------------------------------------------------------
import poser

scene=poser.Scene()
OneActor=scene.CurrentActor()
scene.SetFrame(0)

# Get the geometry and the vert positions
OrigGeom=[]

g=OneActor.Geometry()

#-----------------------------------------------------------------------------
scene.DrawAll()
for i in range(g.NumVertices()):
	#v=g.Vertex(i)
	v=g.WorldVertex(i)
	OrigGeom.append( (v.X(),v.Y(),v.Z()) )

# Now get the deltas
for f in range(scene.NumFrames()):
	print "Frame %.4d" % f
	scene.SetFrame(f)
	scene.DrawAll()
	Name='DMT_%.4d' % (f+1)
	OneActor.AddKeyFrame(f) # needed
	OneActor.SpawnTarget(Name)	# Now create the new
	NewParm = OneActor.Parameter(Name) # Fetch the new parm (Spawn doesn't return anything)
	NewParm.SetValue(1)

	for i in range(g.NumVertices()):
		(oldX,oldY,oldZ)=OrigGeom[i]
		#v=g.Vertex(i)
		v=g.WorldVertex(i)
		newX=v.X()
		newY=v.Y()
		newZ=v.Z()

		NewParm.SetMorphTargetDelta(i,(newX-oldX),(newY-oldY),(newZ-oldZ))
		# put the origs back
		v.SetX(oldX)
		v.SetY(oldY)
		v.SetZ(oldZ)
	# end loop to set verts
	NewParm.SetValue(0)
# end loop on frames

# That should do it.
print "Done. Remember to save the prop under a new name!"

#-----------------------------------------------------------------------------
