#-----------------------------------------------------------------------------
# Coupler
# Copyright (c) 2004, David G. Drumright [ockham].  All rights reserved.
# Jan 20, 2004
#-----------------------------------------------------------------------------

import string
import poser
scene = poser.Scene()
BaseFig = scene.CurrentFigure()
if not BaseFig: raise "Must start with a figure selected"
from Tkinter import *
BasePathUncut=poser.AppLocation()
BasePath=BasePathUncut[:(-len('poser.exe'))]
MyPath=os.path.normpath(BasePath+'/Runtime/Libraries/props/*.PP2')


#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        St = "Coupler: base figure %s " % BaseFig.Name()
        master.title(St)

        self.StatusEntry = Entry(self.master,width=40)
        self.StatusEntry.grid(row=0,column=1)
        self.StatusEntry.insert(0,"Select the followers, then the body parts.")

        # Frames.
        self.FigFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.FigFrame.grid(row=1,column=0, rowspan=1, columnspan=1,sticky=N+S+E,pady=2)
        self.ActorFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ActorFrame.grid(row=1,column=1, rowspan=1, columnspan=1,sticky=N+S+E,pady=2)
        self.ButtonFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ButtonFrame.grid(row=1,column=2, rowspan=1, columnspan=1,sticky=N+S+E,pady=2,padx=4)

        self.FigLabel=Label(self.FigFrame,text="Follower figures:").grid(row=0, column=1,sticky=N)
        self.FigScroll=Scrollbar(self.FigFrame,orient=VERTICAL)
        self.FigScroll.grid(row=1,column=0,sticky=N+S+E)
        self.FigListBox=Listbox(self.FigFrame, height=15, selectmode=MULTIPLE,yscrollcommand=self.FigScroll.set,exportselection=0)
        self.FigListBox.grid(row=1,column=1)
        self.FigScroll["command"]=self.FigListBox.yview

        self.ActorLabel=Label(self.ActorFrame,text="Follower Parts:").grid(row=0, column=1,sticky=N)
        self.ActorScroll=Scrollbar(self.ActorFrame,orient=VERTICAL)
        self.ActorScroll.grid(row=1,column=0,sticky=N+S+E)
        self.ActorListBox=Listbox(self.ActorFrame, height=15, selectmode=MULTIPLE,yscrollcommand=self.ActorScroll.set,exportselection=0)
        self.ActorListBox.grid(row=1,column=1)
        self.ActorScroll["command"]=self.ActorListBox.yview

        # Go/nogo buttons.

        self.buttonAllFigs = Button(self.ButtonFrame, text="All figs", command=self.HandleSelAllFigs)
        self.buttonAllFigs.grid(row=0, column=0)

        self.buttonAllActors = Button(self.ButtonFrame, text="All parts", command=self.HandleSelAllParts)
        self.buttonAllActors.grid(row=1, column=0)

        self.buttonStart = Button(self.ButtonFrame, text="Go", command=self.HandleStart)
        self.buttonStart.grid(row=2, column=0)

        self.buttonCancel = Button(self.ButtonFrame, text="Close", command=self.HandleCancel)
        self.buttonCancel.grid(row=3, column=0)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)

        # Fill the lists.
        for OneFig in scene.Figures():
            if OneFig.Name() != BaseFig.Name():
                self.FigListBox.insert(END,OneFig.Name())

        for OneActor in BaseFig.Actors():
            self.ActorListBox.insert(END,OneActor.Name())


    # - - - - - - - - - - - - - - - - - -
    def HandleSelAllFigs(self):
        self.FigListBox.selection_set(0,END)
    # - - - - - - - - - - - - - - - - - -
    def HandleSelAllParts(self):
        self.ActorListBox.selection_set(0,END)
    # - - - - - - - - - - - - - - - - - -

    def ShowStatus(self,S): # Just saving repetition
        self.StatusEntry.delete(0,END)
        self.StatusEntry.insert(0,S)
        self.StatusEntry.update_idletasks()

    # - - - - - - - - - - - - - - - - - -

    def HandleStart(self):
        self.ShowStatus("Working.....")
        for F in range(scene.NumFrames()):
            scene.SetFrame(F)
            scene.DrawAll()
            self.SetFollowers()
            self.ShowStatus("frame %d" % (F+1))
            scene.DrawAll()
        self.ShowStatus("Done.")
        scene.SetFrame(0)

    # - - - - - - - - - - - - - - - - - -

    def SetFollowers(self):
        FigSels=self.FigListBox.curselection()
        if not FigSels: return
        for F in FigSels:
            FigureName = self.FigListBox.get(int(F))
            FolFigure = scene.Figure(FigureName)
            ActorSels=self.ActorListBox.curselection()
            if not ActorSels: return
            for A in ActorSels:
                ActorName = self.ActorListBox.get(int(A))
                try:
                    BaseActor = BaseFig.Actor(ActorName)
                except:
                    continue
                try:
                    FolActor = FolFigure.Actor(ActorName)
                except:
                    continue

                for FolParm in FolActor.Parameters():
                    ParmName = FolParm.Name()
                    try:
                        BaseValue = BaseActor.Parameter(ParmName).Value()
                    except:
                        continue
                    try:
                        FolParm.SetValue(BaseValue)
                    except:
                        continue
        scene.DrawAll()

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents(1)
        root.lift()
        root.after(250, self.Update)

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
