#-----------------------------------------------------------------------------
# Cut Morph Precision
# Copyright (c) 2005 David G Drumright (ockham)
# 4/26/05

# Cuts all 'd' and 'v' lines to chosen number of decimal places.
#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
import poser
import string
scene = poser.Scene()

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Cut precision")

        self.StatusEntry = Entry(self.master,width=60)
        self.StatusEntry.grid(row=0,column=0,columnspan=4)
        self.StatusEntry.insert(0,"Pick a file")
        Label(self.master,text="Digits after decimal:").grid(row=1,column=0)
        self.PrecEntry = Entry(self.master,width=10)
        self.PrecEntry.grid(row=1,column=1)

        # Go/nogo buttons.
        self.buttonGo = Button(self.master, text="Pick", command=self.HandleGo)
        self.buttonGo.grid(row=1, column=2)

        self.buttonCancel = Button(self.master, text="Cancel", command=self.HandleCancel)
        self.buttonCancel.grid(row=1, column=3)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)


    # - - - - - - - - - - - - - - - - - -
    def ShowStatus(self,S): # Just saving repetition
        self.StatusEntry.delete(0,END)
        self.StatusEntry.insert(0,S)
        self.StatusEntry.update_idletasks()

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents(1)
        root.lift()
        root.after(100, self.Update)

    # - - - - - - - - - - - - - - - - - -

    def HandleName(self):
        # Pop up file box to get name.
        BasePathUncut=poser.AppLocation()
        BasePath=BasePathUncut[:(-len('poser.exe'))]
        MyPath=os.path.normpath(BasePath+'/runtime/libraries/character/*.CR2')
        fn=tkFileDialog.askopenfilename(initialfile=MyPath, defaultextension=[("CR2 file", "*.CR2 *.cr2")] )

        if not fn:
            self.ShowStatus("No file selected. Try again.")
            return 0

        # Open the file
        FullFileName=os.path.abspath(fn)
        return FullFileName
    # - - - - - - - - - - - - - - - - - -

    def HandleGo(self):
        # Action here
        fn=self.HandleName()
        if not fn:
            self.ShowStatus("File not found.")
            return
        NumSt=self.PrecEntry.get()
        if not NumSt:
            Num=4
        else:
            Num=int(NumSt)

        fpIn=open(fn,'rt')
        Front,Ext=os.path.splitext(fn)
        OutFileName=Front+'MOD'+Ext
        fpOut=open(OutFileName,'wt')
        self.ShowStatus("Working on %s" % OutFileName)
        while 1:
            st=fpIn.readline()
            if not st: break
            parts = string.split(st)
            if len(parts)<4:
                fpOut.write(st)
            elif parts[0]=='d':
                i=int(parts[1])
                x=float(parts[2])
                y=float(parts[3])
                z=float(parts[4])
                if (x!=0.0) or (y!=0.0) or (z!=0.0): # Write a delta line only if not all zero.
                    # Build the format string from the Num:
                    FormatSt=r'd %d '+ ('%%.%df %%.%df %%.%df\n' % (Num,Num,Num))
                    fpOut.write(FormatSt % (i,x,y,z) )
            elif parts[0]=='v':
                x=float(parts[1])
                y=float(parts[2])
                z=float(parts[3])
                # Build the format string from the Num:
                FormatSt='v %%.%df %%.%df %%.%df\n' % (Num,Num,Num)
                fpOut.write(FormatSt % (x,y,z) )
            else:
                fpOut.write(st)
        fpIn.close()
        fpOut.close()
        self.ShowStatus("done")

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------

