#------------------------------------------------------------
# Foster parenting v1
# Jan. 19, 2003
# Copyright (c) 2003, David G. Drumright (ockham)
#------------------------------------------------------------

import math
from Tkinter import *
root = Tk()
import poser
scene = poser.Scene()

#------------------------------------------------------------

# Global vars
global GoStandard
global GoTranOnly
global GoTrajMode
global ParentName
global ChildName
global ParentProp
global ParentFig
global ChildProp
global StartFrame
global EndFrame
global NearVert


StartFrame = 0
NearVert = -1
ParentFig = 0
EndFrame = scene.NumFrames() -1
GoStandard = 0
GoTranOnly = 0
GoTrajMode = 0

#------------------------------------------------------------

def GetParentAngle():  # for duplicated code
    global ParentProp
    global ParentFig
    PY = ParentProp.ParameterByCode(poser.kParmCodeYROT).Value()
    PX = ParentProp.ParameterByCode(poser.kParmCodeXROT).Value()
    PZ = ParentProp.ParameterByCode(poser.kParmCodeZROT).Value()
    PBY = 0.0
    PBX = 0.0
    PBZ = 0.0
    if ParentFig:
       ParentBody = ParentFig.Actor("BODY")
       PBY = ParentBody.ParameterByCode(poser.kParmCodeYROT).Value()
       PBX = ParentBody.ParameterByCode(poser.kParmCodeXROT).Value()
       PBZ = ParentBody.ParameterByCode(poser.kParmCodeZROT).Value()
    FullY = PBY + PY
    FullX = PBX + PX
    FullZ = PBZ + PZ
    return FullY, FullX, FullZ

#------------------------------------------------------------

def FindNearestVert(ChildX, ChildY, ChildZ):
    global ParentProp
    global NearVert
    # Find actual position of parent prop by using WorldVertex
    # of the Geometry.  This seems odd, but it wouldn't be necessary
    # if Poser gave us a clean method of locating the Actor;
    # but the WorldDisplacement is incomplete and seems to
    # require some other combination of Figure and actor
    # offsets, which I can't seem to determine.  WorldVertex
    # gives us the actual position all by itself.

    ParentGeom = ParentProp.Geometry()
    MinDist = 1000000.0
    AttachedVertIndex = -1

    ParentVertCount = ParentGeom.NumVertices()
    for i in range(0,ParentVertCount,4):  # skip through; we don't need exact but just a close one
        WV = ParentGeom.WorldVertex(i)
        wX = WV.X()
        wY = WV.Y()
        wZ = WV.Z()
        # Find three-dim distance from Child
        dX = wX - ChildX
        dY = wY - ChildY
        dZ = wZ - ChildZ
        Dist = math.sqrt(dX*dX + dY*dY + dZ*dZ)
        if Dist < MinDist:
           AttachedVertIndex = i
           MinDist = Dist
    if AttachedVertIndex < 0: raise "Finding vertex failed"
    else: NearVert = AttachedVertIndex

#------------------------------------------------------------

def Attach(ThisFrame):
    # Take the present relationship between parent and child
    # as offsets in all three angles and all three dims.
    # Try this: to make the rigid look right, find the center of
    # the parent at this instant, and adjust the three Offset vars
    # of the child so that the child's new center agrees with the
    # parent's center.  This should in fact take the place of my
    # DX,DY,DZ vars.
    # This works in some situations but not in others.
    # Problem is that the Origin vars are not alterable by frame.
    # (This is probably why you can't change parenting during
    # an animation!)
    # So we need to change the original location of the child object
    # to compensate for the change in offset.
    global ParentProp
    global ParentFig
    global ChildProp
    global RigidMode
    global AttachedVertIndex
    global NearVert


    scene.SetFrame(ThisFrame)

    try:
       ParentProp = scene.Actor(ParentName)
    except:
       raise "Parent prop not present"

    # If the Parent is part of a figure, we need to get its
    # angles by a two-step process: the overall angles of the
    # figure, and the angle of this part wrt the figure.
    # There isn't any "world angle" function corresponding
    # to the WorldDisplacement, or if there is, I don't know it!
    try:
       ParentFig = ParentProp.ItsFigure()
    except:
       ParentFig = 0  # Not error, just tells us the parent is simple.

    try:
       ChildProp = scene.Actor(ChildName)
    except:
       raise "Child prop not present"

    # Try this to prevent splining: Set keyframes at every frame
    # before acting.
    for i in range(0, ThisFrame+1):
        ChildProp.AddKeyFrame(i)

    # degug this doesn't throw.  Come back to it.
    #if ParentFig.Parent() == ChildProp:
    #   raise "Already parented: can't use this."
    #if ChildProp.Parent() == ParentFig:
    #   raise "Already parented: can't use this."

    # This is the position of the origin cross at this instant.
    ChildX = ChildProp.Parameter("xTran").Value()
    ChildY = ChildProp.Parameter("yTran").Value()
    ChildZ = ChildProp.Parameter("zTran").Value()

    # Get the parent position
    FindNearestVert(ChildX, ChildY, ChildZ)
    # Get the WV for the nearest vert.  This is not redundant
    # because the Min search went through all.
    ParentGeom = ParentProp.Geometry()
    WV = ParentGeom.WorldVertex(NearVert)
    ParentX = WV.X()
    ParentY = WV.Y()
    ParentZ = WV.Z()

    ChildProp.Parameter("xTran").SetValue(ParentX)
    ChildProp.Parameter("yTran").SetValue(ParentY)
    ChildProp.Parameter("zTran").SetValue(ParentZ)

#------------------------------------------------------------

def FollowRigid(ThisFrame):
    global ParentProp
    global ChildProp
    global NearVert

    # Get figures at present frame.
    scene.SetFrame(ThisFrame)

    # Get angle at this frame

    ThisParentYrot,ThisParentXrot,ThisParentZrot = GetParentAngle()

    ChildYrotParm = ChildProp.ParameterByCode(poser.kParmCodeYROT)
    ChildXrotParm = ChildProp.ParameterByCode(poser.kParmCodeXROT)
    ChildZrotParm = ChildProp.ParameterByCode(poser.kParmCodeZROT)

    ChildYtranParm = ChildProp.ParameterByCode(poser.kParmCodeYTRAN)
    ChildXtranParm = ChildProp.ParameterByCode(poser.kParmCodeXTRAN)
    ChildZtranParm = ChildProp.ParameterByCode(poser.kParmCodeZTRAN)

    ChildX = ChildXtranParm.Value()
    ChildY = ChildYtranParm.Value()
    ChildZ = ChildZtranParm.Value()

    # Get parent tran at this frame
    # Get the WV for the nearest vert.  In this case we re-use the
    # vert found during Attach.
    ParentGeom = ParentProp.Geometry()
    WV = ParentGeom.WorldVertex(NearVert)
    ThisParentXtran = WV.X()
    ThisParentYtran = WV.Y()
    ThisParentZtran = WV.Z()

    # use deltas for angle; for loc, just glue to the vertex.
    NextParentYrot=0.0
    NextParentXrot=0.0
    NextParentZrot=0.0
    NextParentYtran=0.0
    NextParentXtran=0.0
    NextParentZtran=0.0
    if (ThisFrame+1) < (scene.NumFrames()-1):
       scene.SetFrame(ThisFrame+1)
       NextParentYrot,NextParentXrot,NextParentZrot = GetParentAngle()
       # Get the WV for the nearest vert, only for diffs.
       # vert found during Attach.
       WV = ParentGeom.WorldVertex(NearVert)
       NextParentXtran = WV.X()
       NextParentYtran = WV.Y()
       NextParentZtran = WV.Z()

    # Now return to actual frame
    scene.SetFrame(ThisFrame)

    # Set child to new position (not using diffs)
    ChildXtranParm.SetValue(NextParentXtran)
    ChildYtranParm.SetValue(NextParentYtran)
    ChildZtranParm.SetValue(NextParentZtran)

    # Form diffs on angle for actual use
    ParentDXrot  = NextParentXrot - ThisParentXrot
    ParentDYrot  = NextParentYrot - ThisParentYrot
    ParentDZrot  = NextParentZrot - ThisParentZrot

    # Form diffs on tran, only to return for Trajectory.
    ParentDXtran = NextParentXtran - ThisParentXtran
    ParentDYtran = NextParentYtran - ThisParentYtran
    ParentDZtran = NextParentZtran - ThisParentZtran

    # Set new angle
    ChildYrotParm.SetValue(ChildYrotParm.Value() + ParentDYrot)
    ChildXrotParm.SetValue(ChildXrotParm.Value() + ParentDXrot)
    ChildZrotParm.SetValue(ChildZrotParm.Value() + ParentDZrot)

    scene.DrawAll()  # THIS IS CRITICAL! The vert action doesn't work without it.

#------------------------------------------------------------

def FollowTranOnly(ThisFrame):
    global ParentProp
    global ChildProp
    global NearVert
    # Get figures at present frame.
    scene.SetFrame(ThisFrame)

    ChildYtranParm = ChildProp.ParameterByCode(poser.kParmCodeYTRAN)
    ChildXtranParm = ChildProp.ParameterByCode(poser.kParmCodeXTRAN)
    ChildZtranParm = ChildProp.ParameterByCode(poser.kParmCodeZTRAN)

    ChildX = ChildXtranParm.Value()
    ChildY = ChildYtranParm.Value()
    ChildZ = ChildZtranParm.Value()

    # Get parent tran at this frame,only for diffs to trajectory
    # Get the WV for the nearest vert.  In this case we re-use the
    # vert found during Attach.
    ParentGeom = ParentProp.Geometry()
    WV = ParentGeom.WorldVertex(NearVert)
    ParentXtran = WV.X()
    ParentYtran = WV.Y()
    ParentZtran = WV.Z()

    # Set child to new position
    ChildXtranParm.SetValue(ParentXtran)
    ChildYtranParm.SetValue(ParentYtran)
    ChildZtranParm.SetValue(ParentZtran)

    scene.DrawAll()  # THIS IS CRITICAL! The vert action doesn't work without it.

#------------------------------------------------------------

def Detach(ThisFrame):
    global ChildProp
    global ParentProp
    global NearVert

    # For the rest of the total, force the child to stay at the same point we are now.
    for i in (ThisFrame, scene.NumFrames()):
        for Parm in ChildProp.Parameters():
            Parm.DeleteKeyFrame(i)

    # Now, only for trajectory, find the last movement of the parent.
    # (If you set up the frames so that the last few frames have no movement,
    # this will properly give no continuation.)
    # In this case we use the actual Trans of the parent, so that we don't
    # have to fiddle with DrawAll again.
    scene.SetFrame(ThisFrame - 4)
    scene.DrawAll()
    ParentGeom = ParentProp.Geometry()
    WV = ParentGeom.WorldVertex(NearVert)
    FirstXtran = WV.X()
    FirstYtran = WV.Y()
    FirstZtran = WV.Z()

    scene.SetFrame(ThisFrame)
    scene.DrawAll()
    ParentGeom = ParentProp.Geometry()
    WV = ParentGeom.WorldVertex(NearVert)
    LastXtran = WV.X()
    LastYtran = WV.Y()
    LastZtran = WV.Z()

    MX = (LastXtran - FirstXtran) / 3.0
    MY = (LastYtran - FirstYtran) / 3.0
    MZ = (LastZtran - FirstZtran) / 3.0

    return MX, MY, MZ

#------------------------------------------------------------

def Continue(ThisFrame, XMove, YMove, ZMove):
    # Special for Trajectory. Keep moving linearly in same way as
    # the last move when we were attached.
    global ChildProp

    scene.SetFrame(ThisFrame)

    ChildProp.SetSplineBreak(ThisFrame,1) # Be sure we don't get fake interp!

    # Carry on from Detach point until end, in same direction as last move.
    ChildXtranParm = ChildProp.ParameterByCode(poser.kParmCodeXTRAN)
    ChildYtranParm = ChildProp.ParameterByCode(poser.kParmCodeYTRAN)
    ChildZtranParm = ChildProp.ParameterByCode(poser.kParmCodeZTRAN)

    # Note that all of these are additive (delta-ish)
    ChildXtranParm.SetValue(ChildXtranParm.Value() + XMove)
    ChildYtranParm.SetValue(ChildYtranParm.Value() + YMove)
    ChildZtranParm.SetValue(ChildZtranParm.Value() + ZMove)


#------------------------------------------------------------
# Next section is the TK loop, which includes a lot of
# boilerplate stuff.
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.StartVar = IntVar()
        self.StartVar.set(1)  # These are the visible figures
        self.EndVar = IntVar()
        self.EndVar.set(scene.NumFrames())  # These are the visible figures

        self.master = master
        self.master.title("Foster parenting")

        Label(master, text="Parent object:" ).grid(row=1, sticky=W)
        self.ParentTitle = Entry(master)
        self.ParentTitle.grid(row=1, column=2)

        Label(master, text="Child object:" ).grid(row=2, sticky=W)
        self.ChildTitle = Entry(master)
        self.ChildTitle.grid(row=2, column=2)

        Label(master, text="Attach at frame:").grid(row=3, sticky=W)
        self.StartEntry = Entry(master,textvariable=self.StartVar)
        self.StartEntry.grid(row=3, column=2)

        Label(master, text="Detach at frame:").grid(row=4, sticky=W)
        self.EndEntry = Entry(master,textvariable=self.EndVar)
        self.EndEntry.grid(row=4, column=2)


        # buttons for Go (various modes), cancel.
        self.StandardButton = Button(master, text="Standard", command=self.handleGoStandard)
        self.StandardButton.grid(row=5,sticky=W)
        self.TranOnlyButton = Button(master, text="Parallel", command=self.handleGoTranOnly)
        self.TranOnlyButton.grid(row=6,sticky=W)
        self.TrajModeButton = Button(master, text="Trajectory", command=self.handleGoTrajMode)
        self.TrajModeButton.grid(row=7,sticky=W)
        self.buttonCancel = Button(master, text="Cancel", command=self.quit)
        self.buttonCancel.grid(row=8, sticky=W)

        self.ParentTitle.focus_set()  # Start the focus in first blank

    # - - - - - - - - - - - - - - - - - -

    def handleGoStandard(self):
        global GoStandard
        global GoTranOnly
        global GoTrajMode
        global ParentName
        global ChildName
        global StartFrame
        global EndFrame
        # Fetch all the entry boxes:
        try:
          ParentName =  self.ParentTitle.get()
        except:
          raise "No entry in Parent blank"
        try:
          ChildName =  self.ChildTitle.get()
        except:
          raise "No entry in Child blank"
        try:
          StartFrame =  int(self.StartEntry.get()) - 1
        except:
          StartFrame = 0
        try:
          EndFrame =  int(self.EndEntry.get()) - 1
        except:
          EndFrame = scene.NumFrames() - 1

        GoStandard = 1
        GoTranOnly = 0
        GoTrajMode = 0
        self.master.quit()

    # - - - - - - - - - - - - - - - - - -

    def handleGoTranOnly(self):
        global GoStandard
        global GoTranOnly
        global GoTrajMode
        global ParentName
        global ChildName
        global StartFrame
        global EndFrame
        # Fetch all the entry boxes:
        try:
          ParentName =  self.ParentTitle.get()
        except:
          raise "No entry in Parent blank"
        try:
          ChildName =  self.ChildTitle.get()
        except:
          raise "No entry in Child blank"
        try:
          StartFrame =  int(self.StartEntry.get()) - 1
        except:
          StartFrame = 0
        try:
          EndFrame =  int(self.EndEntry.get()) - 1
        except:
          EndFrame = scene.NumFrames() - 1

        GoStandard = 0
        GoTranOnly = 1
        GoTrajMode = 0
        self.master.quit()

    # - - - - - - - - - - - - - - - - - -

    def handleGoTrajMode(self):
        global GoStandard
        global GoTranOnly
        global GoTrajMode
        global ParentName
        global ChildName
        global StartFrame
        global EndFrame
        # Fetch all the entry boxes:
        try:
          ParentName =  self.ParentTitle.get()
        except:
          raise "No entry in Parent blank"
        try:
          ChildName =  self.ChildTitle.get()
        except:
          raise "No entry in Child blank"
        try:
          StartFrame =  int(self.StartEntry.get()) - 1
        except:
          StartFrame = 0
        try:
          EndFrame =  int(self.EndEntry.get()) - 1
        except:
          EndFrame = scene.NumFrames() - 1

        GoStandard = 0
        GoTranOnly = 0
        GoTrajMode = 1
        self.master.quit()

    # - - - - - - - - - - - - - - - - - -


    def quit(self):
        global GoStandard
        global GoTranOnly
        global GoTrajMode
        GoStandard = 0
        GoTranOnly = 0
        GoTrajMode = 0
        self.master.quit()

#------------------------------------------------------------
# Activate the Win loop, which will be broken by any button.
#------------------------------------------------------------

app = App(root, '')
root.mainloop()

#------------------------------------------------------------
global GoStandard
global GoTranOnly
global GoTrajMode

if   GoStandard:
     Attach(StartFrame)
     for f in range(StartFrame,EndFrame+1):
        FollowRigid(f)
     ChildProp.DeleteKeyFrame(StartFrame) # Makes nice gradual pickup
     Detach(EndFrame)

elif GoTranOnly:
     Attach(StartFrame)
     for f in range(StartFrame,EndFrame+1):
         FollowTranOnly(f)

     ChildProp.DeleteKeyFrame(StartFrame) # Makes nice gradual pickup
     Detach(EndFrame)

elif GoTrajMode:
     Attach(StartFrame)
     newDX=0.0
     newDY=0.0
     newDZ=0.0
     SDX=0.0
     SDY=0.0
     SDZ=0.0
     for f in range(StartFrame,EndFrame+1):
         FollowRigid(f)

     # Get the last movement.
     MX,MY,MZ = Detach(EndFrame)
     for f in range(EndFrame,(scene.NumFrames()-1)):
         Continue(f,MX,MY,MZ)

     ChildProp.DeleteKeyFrame(StartFrame) # Makes nice gradual pickup

scene.SetFrame(0)

#------------------------------------------------------------
