#-----------------------------------------------------------------------------
# Magnet follower, for Tguyus
# June 2, 2004
# Copyright (c) 2004, David G. Drumright [ockham]
#-----------------------------------------------------------------------------
'''

Script gives

1. list of all mags in scene
2. list of parms on any magnet
3. list of parms on the selected Actor
4. Entry for default and multiplier

Select the actor before starting the script.
You pick mags, pick the parm to be influenced on mags, pick the actor and parm on
the figure, and set the proportion.
Hit go to make the parm influence these mags (parm * proportion = mag prop)
'''

#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
import sys
import os
import poser
import pickle
syslist=sys.path
MyPath=os.path.abspath(syslist[-1]+"/*.DAT")

scene = poser.Scene()

ActorName=''
TheActor=scene.CurrentActor()
ActorName=TheActor.Name()
try:
    TheFig=TheActor.ItsFigure()
except:
    TheFig=0

#-----------------------------------------------------------------------------
# Global vars
#-----------------------------------------------------------------------------
global ListOfMags
global ListOfMagParms
global ListOfActorParms
ListOfMags=[]
ListOfMagParms=[]
ListOfActorParms=[]

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Mag modifier")

        self.ActorFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.MagFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ActorFrame.grid(row=0,column=0,sticky=N+S+E,pady=2)
        self.MagFrame.grid(row=0,column=1,sticky=N+S+E,pady=2)
        self.ValFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ValFrame.grid(row=1,column=0,sticky=N+S+E,pady=2)
        self.ButFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ButFrame.grid(row=1,column=1,sticky=N+S+E,pady=2)

        self.MagLabel=Label(self.MagFrame,text="Magnets:").grid(row=0, column=1,sticky=N)
        self.MagScroll=Scrollbar(self.MagFrame, orient=VERTICAL)
        self.MagScroll.grid(row=1, column=0,sticky=N+S+E)
        self.MagListBox=Listbox(self.MagFrame, height=15, selectmode=MULTIPLE,yscrollcommand=self.MagScroll.set,exportselection=0)
        self.MagListBox.grid( row=1, column=1)
        self.MagScroll["command"]=self.MagListBox.yview

        self.MagParmLabel=Label(self.MagFrame,text="Mag Parms:").grid(row=0, column=3,sticky=N)
        self.MagParmScroll=Scrollbar(self.MagFrame, orient=VERTICAL)
        self.MagParmScroll.grid(row=1, column=2,sticky=N+S+E)
        self.MagParmListBox=Listbox(self.MagFrame, height=15, selectmode=SINGLE,yscrollcommand=self.MagParmScroll.set,exportselection=0)
        self.MagParmListBox.grid( row=1, column=3)
        self.MagParmScroll["command"]=self.MagParmListBox.yview

        APtext="%s Parms:" % TheActor.Name()
        self.ActorParmLabel=Label(self.ActorFrame,text=APtext).grid(row=0, column=1,sticky=N)
        self.ActorParmScroll=Scrollbar(self.ActorFrame, orient=VERTICAL)
        self.ActorParmScroll.grid(row=1, column=0,sticky=N+S+E)
        self.ActorParmListBox=Listbox(self.ActorFrame, height=15, selectmode=SINGLE,yscrollcommand=self.ActorParmScroll.set,exportselection=0)
        self.ActorParmListBox.grid( row=1, column=1)
        self.ActorParmScroll["command"]=self.ActorParmListBox.yview
        # Fill the lists.
        self.FillMagList()
        self.FillMagParmList()
        self.FillActorParmList()


        Label(self.ValFrame,text="Default for driver:").grid(row=0, column=0)
        self.SrcDefaultEntry = Entry(self.ValFrame,width=8)
        self.SrcDefaultEntry.grid(row=0,column=1)

        Label(self.ValFrame,text="Default for mags:").grid(row=1, column=0)
        self.MagDefaultEntry = Entry(self.ValFrame,width=8)
        self.MagDefaultEntry.grid(row=1,column=1)

        Label(self.ValFrame,text="Multiply by").grid(row=2, column=0)
        self.MultEntry = Entry(self.ValFrame,width=8)
        self.MultEntry.grid(row=2,column=1)

        Label(self.ValFrame,text="Start frame").grid(row=3,column=0)
        self.StartFrameEntry=Entry(self.ValFrame,width=8)
        self.StartFrameEntry.grid(row=3,column=1,sticky=W,pady=3)

        Label(self.ValFrame,text="End frame").grid(row=4,column=0,pady=3)
        self.EndFrameEntry=Entry(self.ValFrame,width=8)
        self.EndFrameEntry.grid(row=4,column=1,sticky=W,pady=3)

        # Put defaults
        self.SrcDefaultEntry.insert(0,str(0.0))
        self.MagDefaultEntry.insert(0,str(0.0))
        self.MultEntry.insert(0,str(1.0))
        self.StartFrameEntry.insert(0,str(1))
        self.EndFrameEntry.insert(0,str(scene.NumFrames()))

        # Go/nogo buttons.
        self.buttonGet = Button(self.ButFrame, text="Get data", command=self.GetData)
        self.buttonGet.grid(row=0, column=0,pady=3)

        self.buttonPut = Button(self.ButFrame, text="Save data", command=self.PutData)
        self.buttonPut.grid(row=0, column=2,pady=3)

        self.buttonGo = Button(self.ButFrame, text="Go", command=self.handleGo)
        self.buttonGo.grid(row=1, column=0,sticky=E+W,pady=3)

        self.buttonCancel = Button(self.ButFrame, text="Cancel", command=self.handleCancel)
        self.buttonCancel.grid(row=1, column=2,sticky=E+W,pady=3)

    # - - - - - - - - - - - - - - - - - -

    def FillMagList(self):
        global ListOfMags
        # Clear then refill the Parm list
        # In the visible list, add the part that the mag is on.

        ListOfMags =[] # clear the internal
        self.MagListBox.delete(0,END) # clear the visible
        for OneMag in scene.Actors():
            if OneMag.IsDeformer():
                ListOfMags.append(OneMag.InternalName())
                Base=OneMag.Parent()
                RealParent=Base.Parent()
                MLtext="%s (%s)" % (OneMag.Name(),RealParent.Name())
                self.MagListBox.insert(END,MLtext)

    # - - - - - - - - - - - - - - - - - -
    def FillMagParmList(self):
        global ListOfMagParms
        # This is hard-wired, using the standard list of mag parms.
        ListOfMagParms = ["scale","xScale","yScale","zScale","yrot","xrot","zrot","xtran","ytran","ztran"]
        # Put the external names into the visible ListBox.
        self.MagParmListBox.insert(END,"Scale")
        self.MagParmListBox.insert(END,"xScale")
        self.MagParmListBox.insert(END,"yScale")
        self.MagParmListBox.insert(END,"zScale")
        self.MagParmListBox.insert(END,"yRotate")
        self.MagParmListBox.insert(END,"xRotate")
        self.MagParmListBox.insert(END,"zRotate")
        self.MagParmListBox.insert(END,"xTran")
        self.MagParmListBox.insert(END,"yTran")
        self.MagParmListBox.insert(END,"zTran")

    # - - - - - - - - - - - - - - - - - -
    def FillActorParmList(self):
        global ListOfActorParms
        # Since you've selected the Actor first, we can fill this in directly.
        ListOfActorParms =[] # clear the internal
        self.ActorParmListBox.delete(0,END) # clear the visible
        for OneParm in TheActor.Parameters():
            if not OneParm.Hidden():
                ListOfActorParms.append(OneParm.InternalName())
                self.ActorParmListBox.insert(END,OneParm.Name())

    # - - - - - - - - - - - - - - - - - -
    def GetData(self):
        fn=tkFileDialog.askopenfilename(initialfile=MyPath)
        if not fn: return  # No error
        TempName=os.path.abspath(fn)
        fp=open(TempName,'rt')
        L=pickle.load(fp)
        [SD,MD,M,SF,EF,ParmSel,MagSels,MagParm]=L
        fp.close()
        # Clear the entries
        self.SrcDefaultEntry.delete(0,END)
        self.MagDefaultEntry.delete(0,END)
        self.MultEntry.delete(0,END)
        self.StartFrameEntry.delete(0,END)
        self.EndFrameEntry.delete(0,END)

        self.SrcDefaultEntry.insert(0,str(SD))
        self.MagDefaultEntry.insert(0,str(MD))
        self.MultEntry.insert(0,str(M))
        self.StartFrameEntry.insert(0,str(SF))
        self.EndFrameEntry.insert(0,str(EF))
        # Try to set the selections from the earlier session.
        # If fail, give error.
        try:
            self.ActorParmListBox.selection_set(ParmSel)
        except:
            raise "Earlier data doesn't match this figure!"
        for OneMS in MagSels:
            try:
                self.MagListBox.selection_set(OneMS)
            except:
                raise "Earlier data doesn't match this figure!"
        try:
            self.MagParmListBox.selection_set(MagParm)
        except:
            raise "Earlier data doesn't match this figure!"


    # - - - - - - - - - - - - - - - - - -
    def PutData(self):
        SDS = self.SrcDefaultEntry.get()
        MDS = self.MagDefaultEntry.get()
        MS  = self.MultEntry.get()
        SFS  = self.StartFrameEntry.get()
        EFS  = self.EndFrameEntry.get()
        if SDS:
            SD = float(SDS)
        else:
            SD = 0.0
        if MDS:
            MD = float(MDS)
        else:
            MD = 0.0

        if MS:
            M = float(MS)
        else:
            M = 1.0  # No change if you miss

        if SFS:
            SF = int(SFS)
        else:
            SF = 1

        if EFS:
            EF = int(EFS)
        else:
            EF = scene.NumFrames()
        ParmSel=self.ActorParmListBox.curselection()
        MagSels=self.MagListBox.curselection()
        MagParm=self.MagParmListBox.curselection()

        L=[SD,MD,M,SF,EF,ParmSel,MagSels,MagParm]
        # Use pop-up to find a name
        fn=tkFileDialog.asksaveasfilename(initialfile=MyPath)
        if not fn:
            return

        TempName=os.path.abspath(fn)
        try:
            fp=open(TempName,'wt')
        except:
            raise "Bad file"
        pickle.dump(L,fp)
        fp.close()

    # - - - - - - - - - - - - - - - - - -

    def Action(self):
        # Get the numbers first:
        SrcDefaultString = self.SrcDefaultEntry.get()
        MagDefaultString = self.MagDefaultEntry.get()
        MultString = self.MultEntry.get()
        StartFrameString = self.StartFrameEntry.get()
        EndFrameString = self.EndFrameEntry.get()

        if SrcDefaultString:
            SrcDefaultValue = float(SrcDefaultString)
        else:
            SrcDefaultValue = 0.0

        if MagDefaultString:
            MagDefaultValue = float(MagDefaultString)
        else:
            MagDefaultValue = 0.0

        if MultString:
            Multiplier = float(MultString)
        else:
            Multiplier = 1.0  # No change if you miss

        if StartFrameString:
            StartFrame = int(StartFrameString)
        else:
            StartFrame = 1

        if EndFrameString:
            EndFrame = int(EndFrameString)
        else:
            EndFrame = scene.NumFrames()

        # Get the selections:
        Sels=self.ActorParmListBox.curselection() # single
        ActorParmName=self.ActorParmListBox.get(int(Sels[0]))
        ActorParm=TheActor.Parameter(ActorParmName)
        Sels=self.MagParmListBox.curselection() # single
        MagParmName=self.MagParmListBox.get(int(Sels[0]))

        Sels=self.MagListBox.curselection() # multiple
        for OneSel in Sels:
            OneMagName = ListOfMags[int(OneSel)]
            OneMag = scene.ActorByInternalName(OneMagName)
            for F in range(StartFrame,EndFrame+1): # Now change the value at each point
                scene.SetFrame(F-1)
                MagParm=OneMag.Parameter(MagParmName)
                Src=ActorParm.Value()
                Dest = MagDefaultValue + ((Src - SrcDefaultValue) * Multiplier)
                MagParm.SetValue(Dest)


    # - - - - - - - - - - - - - - - - - -

    def handleGo(self):
        self.Action()
        # Doesn't quit automatically; you can hit Save if you like the result.

    # - - - - - - - - - - - - - - - - - -

    def handleCancel(self):
        self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
