#-----------------------------------------------------------------------------
# Move Lots of Props (extension of Emphasizer)
# Nov 16, 2004
# Copyright (c) 2004, David G. Drumright [ockham]
#-----------------------------------------------------------------------------

from Tkinter import *
import poser
import string
import random

scene = poser.Scene()
random.seed()

#-----------------------------------------------------------------------------
# Global vars
global ParmList

# Prefill the parm list.
ParmList=["Scale","xScale","yScale","zScale","xRotate","yRotate","zRotate","xTran","yTran","zTran"]
#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        global Go
        Go = 0
        self.master = master
        master.title("Move lots of props")

        self.PropsFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ParmsFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.EntryFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.PropsFrame.grid(row=0,column=0,sticky=N+S+E,pady=2)
        self.ParmsFrame.grid(row=0,column=1,sticky=N+S+E,pady=2)
        self.EntryFrame.grid(row=1,column=0,columnspan=2)

        self.ParmLabel=Label(self.ParmsFrame,text="Parameters:").grid(row=0, column=1,sticky=N)
        self.ParmScroll=Scrollbar(self.ParmsFrame, orient=VERTICAL)
        self.ParmScroll.grid(row=1, column=0,sticky=N+S+E)
        self.ParmListBox=Listbox(self.ParmsFrame, height=15, selectmode=MULTIPLE,yscrollcommand=self.ParmScroll.set,exportselection=0)
        self.ParmListBox.grid( row=1, column=1)
        self.ParmScroll["command"]=self.ParmListBox.yview

        self.PropLabel=Label(self.PropsFrame,text="Props:").grid(row=0, column=1,sticky=N)
        self.PropScroll=Scrollbar(self.PropsFrame, orient=VERTICAL)
        self.PropScroll.grid(row=1, column=0,sticky=N+S+E)
        self.PropListBox=Listbox(self.PropsFrame, height=15, selectmode=MULTIPLE,yscrollcommand=self.ParmScroll.set,exportselection=0)
        self.PropListBox.grid( row=1, column=1)
        self.PropScroll["command"]=self.PropListBox.yview

        self.FillPropList()
        self.FillParmList()

        Label(self.EntryFrame,text="Multiply by").grid(row=0,sticky=E, column=0)
        self.MultEntry = Entry(self.EntryFrame,width=8)
        self.MultEntry.grid(row=0,column=1)
        self.MultEntry.insert(0,str(1.0))

        Label(self.EntryFrame,text="Offset by").grid(row=1,sticky=E, column=0)
        self.AddEntry = Entry(self.EntryFrame,width=8)
        self.AddEntry.grid(row=1,column=1)
        self.AddEntry.insert(0,str(0.0))

        Label(self.EntryFrame,text="Random percent").grid(row=2,sticky=E, column=0)
        self.RandEntry = Entry(self.EntryFrame,width=8)
        self.RandEntry.grid(row=2,column=1)
        self.RandEntry.insert(0,str(0.0))

        Label(self.EntryFrame,text="Sparseness (frames)").grid(row=3,sticky=E, column=0)
        self.SkipEntry = Entry(self.EntryFrame,width=8)
        self.SkipEntry.grid(row=3,column=1)
        self.SkipEntry.insert(0,str(1))

        Label(self.EntryFrame,text="Start frame").grid(row=4,sticky=E,column=0)
        self.StartFrameEntry=Entry(self.EntryFrame,width=8)
        self.StartFrameEntry.grid(row=4,column=1,sticky=W,pady=3)
        self.StartFrameEntry.insert(0,str(1))

        Label(self.EntryFrame,text="End frame").grid(row=5,column=0,sticky=E,pady=3)
        self.EndFrameEntry=Entry(self.EntryFrame,width=8)
        self.EndFrameEntry.grid(row=5,column=1,sticky=W,pady=3)
        self.EndFrameEntry.insert(0,str(scene.NumFrames()))

        # Go/nogo buttons.
        self.buttonGo = Button(self.master, text="Go", command=self.handleGo)
        self.buttonGo.grid(row=3, column=0)

        self.buttonCancel = Button(self.master, text="Cancel", command=self.handleCancel)
        self.buttonCancel.grid(row=3, column=2)

    # - - - - - - - - - - - - - - - - - -

    def FillParmList(self):
        # Clear then refill the Parm list
        global ParmList
        # Internal list is pre-filled with standard.
        self.ParmListBox.delete(0,END) # clear
        # Here we just copy those into the tk list.
        for OneName in ParmList:
            self.ParmListBox.insert(END,OneName)

    # - - - - - - - - - - - - - - - - - -

    def FillPropList(self):
        # Clear then refill the Prop list
        self.PropListBox.delete(0,END) # clear
        for OneProp in scene.Actors():
            if OneProp.IsProp():
                self.PropListBox.insert(END,OneProp.Name())

    # - - - - - - - - - - - - - - - - - -

    def Action(self):
        # Pick up the Multiplier. For each actor, and each parm,
        # apply the given value.
        StartFrameString = self.StartFrameEntry.get()
        EndFrameString = self.EndFrameEntry.get()
        MultString = self.MultEntry.get()
        AddString  = self.AddEntry.get()
        RandString = self.RandEntry.get()
        SkipString = self.SkipEntry.get()

        if StartFrameString:
            StartFrame = int(StartFrameString)-1
        else:
            StartFrame = 0

        if EndFrameString:
            EndFrame = int(EndFrameString)
        else:
            EndFrame = scene.NumFrames()

        if MultString:
            Multiplier = float(MultString)
        else:
            Multiplier = 0.0  # No change if you miss

        if AddString:
            Adder      = float(AddString)
        else:
            Adder = 0.0  # No change if you miss

        if RandString:
            Rand      = float(RandString) * 0.01
        else:
            Rand = 0.0  # No change if you miss

        if SkipString:
            Skip      = int(SkipString)
        else:
            Skip = 1  # Min


        # Get the selections:
        ParmSels=self.ParmListBox.curselection()
        if not ParmSels: return
        PropSels=self.PropListBox.curselection()
        if not PropSels: return

        for OneParmSel in ParmSels:
            OneParmName = ParmList[int(OneParmSel)]
            for OnePropSel in PropSels:
                OneActor=scene.Actor(self.PropListBox.get(int(OnePropSel)))
                OneParm = OneActor.Parameter(OneParmName)
                if string.count(string.upper(OneParmName),'SCALE'):
                    RealAdder=Adder/100.0
                else:
                    RealAdder=Adder
                for F in range(StartFrame,EndFrame,Skip): # First force keyframes
                    scene.SetFrame(F)
                    OneParm.AddKeyFrame(F)
                for F in range(StartFrame,EndFrame,Skip): # Now change the value at each point
                    scene.SetFrame(F)
                    RandMul=1.0 + Rand*(random.random()-0.5)
                    OneParm.SetValue(OneParm.Value()*Multiplier+RealAdder)
                    OneParm.SetValue(OneParm.Value()*RandMul)

    # - - - - - - - - - - - - - - - - - -

    def handleGo(self):
        self.Action()
        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def handleCancel(self):
        self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
