#-----------------------------------------------------------------------------
# Repeater
# Copyright (c) 2004, David G. Drumright.  All rights reserved.
# Jan 25, 2004
#-----------------------------------------------------------------------------

import poser
scene = poser.Scene()
BaseFig = scene.CurrentFigure()
if not BaseFig: raise "Must start with a figure selected"
from Tkinter import *

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        St = "Repeater: figure %s " % BaseFig.Name()
        master.title(St)

        self.StatusEntry = Entry(self.master,width=40)
        self.StatusEntry.grid(row=0,column=0,columnspan=2)
        self.StatusEntry.insert(0,"Select the range to repeat, and the body parts.")

        # Frames.
        self.ActorFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ActorFrame.grid(row=1,column=0, sticky=N+S+E,pady=2)

        self.ButtonFrame=Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ButtonFrame.grid(row=1,column=1,sticky=N+S+E,pady=2,padx=4)

        self.ActorLabel=Label(self.ActorFrame,text="Parts:").grid(row=0, column=1,sticky=N)
        self.ActorScroll=Scrollbar(self.ActorFrame,orient=VERTICAL)
        self.ActorScroll.grid(row=1,column=0,sticky=N+S+E)
        self.ActorListBox=Listbox(self.ActorFrame, height=15, selectmode=MULTIPLE,yscrollcommand=self.ActorScroll.set,exportselection=0)
        self.ActorListBox.grid(row=1,column=1)
        self.ActorScroll["command"]=self.ActorListBox.yview

        # Entries and buttons

        Label(self.ButtonFrame,text="Start Frame of source").grid(row=2,column=0)
        self.StartFrameEntry = Entry(self.ButtonFrame,width=10)
        self.StartFrameEntry.grid(row=2,column=1)

        Label(self.ButtonFrame,text="End Frame of source").grid(row=3,column=0)
        self.EndFrameEntry = Entry(self.ButtonFrame,width=10)
        self.EndFrameEntry.grid(row=3,column=1)

        Label(self.ButtonFrame,text="Begin repeats at:").grid(row=4,column=0)
        self.FromFrameEntry = Entry(self.ButtonFrame,width=10)
        self.FromFrameEntry.grid(row=4,column=1)

        Label(self.ButtonFrame,text="Repeat how many times").grid(row=5,column=0)
        self.HowManyEntry = Entry(self.ButtonFrame,width=10)
        self.HowManyEntry.grid(row=5,column=1)

        self.buttonStart = Button(self.ButtonFrame, text="Go", command=self.HandleStart)
        self.buttonStart.grid(row=6, column=0)

        self.buttonCancel = Button(self.ButtonFrame, text="Close", command=self.HandleCancel)
        self.buttonCancel.grid(row=6, column=1)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)

        # Fill the lists.
        for OneActor in BaseFig.Actors():
            self.ActorListBox.insert(END,OneActor.Name())


    # - - - - - - - - - - - - - - - - - -

    def ShowStatus(self,S): # Just saving repetition
        self.StatusEntry.delete(0,END)
        self.StatusEntry.insert(0,S)
        self.StatusEntry.update_idletasks()

    # - - - - - - - - - - - - - - - - - -

    def HandleStart(self):
        self.ShowStatus("Working.....")
        # Get the start, end, and repeat.

        S = self.StartFrameEntry.get()
        try:
            StartFrame = int(S) - 1
        except:
            StartFrame = 0

        S = self.EndFrameEntry.get()
        try:
            EndFrame = int(S) - 1
        except:
            EndFrame = scene.NumFrames() -1

        S = self.FromFrameEntry.get()
        try:
            From = (int(S) - 1) - EndFrame + 1
        except:
            From = 1
        # Yes, the arithmetic is redundant.  I'm trying
        # to make clear that
        # Reminder: what we need internally is a number
        # to add onto source.  The default
        # here gives us an adder of 1, so that the first
        # rep starts just after the end of source.

        S = self.HowManyEntry.get()
        try:
            Times = int(S)
        except:
            Times = 1

        SourceLen = EndFrame - StartFrame + 1

        # Get the selected actors:
        Sels = self.ActorListBox.curselection()
        if not Sels: # Assume you meant to select all.
            self.ActorListBox.selection_set(0,END)

        Sels = self.ActorListBox.curselection()
        for OneSel in Sels:
            Name = self.ActorListBox.get(int(OneSel))
            OneActor = BaseFig.Actor(Name)
            # Outermost loop is on the Actor;
            # then by Parm.
            # For each Parm, run through the source frames.
            # Pick up the value at this source frame, then repeat it HowMany times,
            # jumping ahead by length of source.
            self.ShowStatus("Working on %s" % (Name))
            for OneParm in OneActor.Parameters():
                for SourceFrame in range(StartFrame,EndFrame):
                    scene.SetFrame(SourceFrame)
                    Val = OneParm.Value()
                    for OneRep in range(Times):
                        DestFrame = SourceFrame + From + (SourceLen * (OneRep+1))
                        scene.SetFrame(DestFrame)
                        OneParm.SetValue(Val)

        self.ShowStatus("Done.")
        scene.SetFrame(0)

    # - - - - - - - - - - - - - - - - - -

    def SetFollowers(self):
        FigSels=self.FigListBox.curselection()
        if not FigSels: return
        for F in FigSels:
            FigureName = self.FigListBox.get(int(F))
            FolFigure = scene.Figure(FigureName)
            ActorSels=self.ActorListBox.curselection()
            if not ActorSels: return
            for A in ActorSels:
                ActorName = self.ActorListBox.get(int(A))
                try:
                    BaseActor = BaseFig.Actor(ActorName)
                except:
                    continue
                try:
                    FolActor = FolFigure.Actor(ActorName)
                except:
                    continue

                for FolParm in FolActor.Parameters():
                    ParmName = FolParm.Name()
                    try:
                        BaseValue = BaseActor.Parameter(ParmName).Value()
                    except:
                        continue
                    try:
                        FolParm.SetValue(BaseValue)
                    except:
                        continue
        scene.DrawAll()

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents(1)
        root.lift()
        root.after(250, self.Update)

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
