#-----------------------------------------------------------------------------
# ReplaceProps
# Copyright (c) 2004 David G. Drumright (Ockham)
# Nov. 15, 2004
# Delete the selected items.
# Replace the deleted items with copies of a new selected prop.
#-----------------------------------------------------------------------------

from Tkinter import *
import tkFileDialog
import poser
import os
scene = poser.Scene()

#-----------------------------------------------------------------------------
Deletables={}  # Dict so we can avoid redundancy
global Deletables
def FindDeletables(Name):
    global Deletables
    ActorArg=scene.Actor(Name)
    Xt=ActorArg.ParameterByCode(poser.kParmCodeXTRAN).Value()
    Yt=ActorArg.ParameterByCode(poser.kParmCodeYTRAN).Value()
    Zt=ActorArg.ParameterByCode(poser.kParmCodeZTRAN).Value()
    Xr=ActorArg.ParameterByCode(poser.kParmCodeXROT).Value()
    Yr=ActorArg.ParameterByCode(poser.kParmCodeYROT).Value()
    Zr=ActorArg.ParameterByCode(poser.kParmCodeZROT).Value()
    Deletables[Name]=(Xt,Yt,Zt,Xr,Yr,Zr)

#-----------------------------------------------------------------------------
# Next section is TK
#------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Prop replacer")
        self.FileName=''

        Label(self.master,text="Highlight props in list, then hit Go to pick new").grid(row=1, column=0,columnspan=3)

        # Lists
        self.ListScroll = Scrollbar(self.master, orient=VERTICAL)
        self.ListScroll.grid( row=2, column=0,sticky=N+S+E)
        self.List = Listbox(self.master, height=25, selectmode=MULTIPLE,yscrollcommand = self.ListScroll.set)
        self.List.grid( row=2, column=1)
        # Set the scrollbar to work
        self.ListScroll["command"] = self.List.yview
        # Fill list with all PP2 in the scene
        for OneActor in scene.Actors():
            if (OneActor.IsProp()) and ( OneActor.Name() != 'GROUND'):
                Name=OneActor.Name()
                self.List.insert(END,Name)

        # Go/nogo buttons.
        self.buttonGo = Button(self.master, text="Go", command=self.HandleGo)
        self.buttonGo.grid(row=3, column=0)

        self.buttonCancel = Button(self.master, text="Cancel", command=self.HandleCancel)
        self.buttonCancel.grid(row=3, column=2)

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)


    # - - - - - - - - - - - - - - - - - -

    def Update(self):
        if scene: scene.ProcessSomeEvents(1)
        root.lift()
        root.after(100, self.Update)

    # - - - - - - - - - - - - - - - - - -

    def HandleGo(self):
        # Pop up file box to get name.
        BasePathUncut=poser.AppLocation()
        BasePath=BasePathUncut[:(-len('poser.exe'))]
        MyPath=os.path.normpath(BasePath+'/runtime/libraries/props/*.PP2')
        fn=tkFileDialog.askopenfilename(initialfile=MyPath, filetypes=[("New PP2 file", "*.PP2 *.pp2")] )

        if not fn:
            raise "No file selected. Try again."

        Sels=self.List.curselection()
        if not Sels:  # Do all in list
            for OneIndex in range(self.List.size()):
                ActorName=self.List.get(OneIndex)
                FindDeletables(ActorName)
        else: # Sels
            for OneIndex in Sels:
                ActorName=self.List.get(int(OneIndex))
                FindDeletables(ActorName)
        # Now take the list formed by FindDeletables, and delete
        # everything in it, then replace with new prop in same position.
        for OneName in Deletables.keys():
            scene.SelectActor(scene.Actor(OneName))
            scene.DeleteCurrentProp()
            try:
                scene.LoadLibraryProp(os.path.normpath(fn))
            except:
                raise "Can't load %s" % fn

            NewProp=scene.CurrentActor()
            (Xt,Yt,Zt,Xr,Yr,Zr)=Deletables[OneName]
            NewProp.ParameterByCode(poser.kParmCodeXTRAN).SetValue(Xt)
            NewProp.ParameterByCode(poser.kParmCodeYTRAN).SetValue(Yt)
            NewProp.ParameterByCode(poser.kParmCodeZTRAN).SetValue(Zt)
            NewProp.ParameterByCode(poser.kParmCodeXROT).SetValue(Xr)
            NewProp.ParameterByCode(poser.kParmCodeYROT).SetValue(Yr)
            NewProp.ParameterByCode(poser.kParmCodeZROT).SetValue(Zr)
            scene.DrawAll()

        self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

root = Tk()
app = App(root, '')
app.Update()
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
