#-----------------------------------------------------------------------------
# SetMatsToColor
# Jan. 31, 2005
# Copyright (c) 2005, David G. Drumright (ockham)
#-----------------------------------------------------------------------------

from Tkinter import *
root = Tk()

import poser
import string
scene = poser.Scene()

#-----------------------------------------------------------------------------
# Global vars
#----------------------------------------------------------------------------
global Red,Green,Blue
global MatList
global ListToMemorize
global NoTex
global NoTrans

MatList = []
ListToMemorize = [] # Holds both Actors and Figures
Red = 0.0
Green = 0.0
Blue = 0.0
NoTex=0
NoTrans=0


#-----------------------------------------------------------------------------

def MainAction():
    global Red,Green,Blue
    global MatList,ListToMemorize
    global NoTex, NoTrans

    # Find by using the Mats in Matlist.  The ListToMemorize runs
    # in parallel, and is needed so we can do the Memorize step.
    # When we are running from selections, the NONselected Mats
    # will have been set to 0 by HandleSelect, so we can just skip them.
    for Index in range(len(MatList)):
        if MatList[Index] != 0: # If this was selected
            OneMat = MatList[Index]
            OneMat.SetDiffuseColor(Red,Green,Blue)
            #OneMat.SetAmbientColor(Red,Green,Blue)
            #OneMat.SetReflectionColor(Red,Green,Blue)
            #OneMat.SetSpecularColor(Red,Green,Blue)
            if NoTex:
                OneMat.SetTextureMapFileName(None)
            if NoTrans:
                OneMat.SetTransparencyMapFileName(None)
            ThingToMemorize = ListToMemorize[Index]
            ThingToMemorize.Memorize()

#-----------------------------------------------------------------------------

class App:
    def __init__(self, master, textMessage):
        self.master = master
        master.title("Select materials, set to chosen values")

        self.ListFrame = Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ListFrame.grid(row=2,column=1, rowspan=1, columnspan=1,sticky=E+W+N+S)

        self.ButtonFrame = Frame(self.master,borderwidth=2,relief=RIDGE)
        self.ButtonFrame.grid(row=2,column=2, rowspan=1, columnspan=1,sticky=E+W+N+S)

        # Vars to handle the Checkbuttons:
        self.NoTexVar = IntVar()
        self.NoTexVar.set(-1) # default for no change
        self.NoTransVar = IntVar()
        self.NoTransVar.set(-1) # default for no change

        # The leader info goes across the top.
        self.NoTexLabel = Label(self.ButtonFrame,text="Check to delete textures").grid(row=1, column=0)
        self.NoTexCheck = Checkbutton(self.ButtonFrame,variable=self.NoTexVar)
        self.NoTexCheck.grid(row=1,column=1)
        self.NoTexLabel = Label(self.ButtonFrame,text="Check to delete transmaps").grid(row=2, column=0)
        self.NoTransCheck = Checkbutton(self.ButtonFrame,variable=self.NoTransVar)
        self.NoTransCheck.grid(row=2,column=1)

        self.RedLabel = Label(self.ButtonFrame,text="Red").grid(row=3, column=0)
        self.RedSlide = Scale(self.ButtonFrame, from_= 0.0, to=255.0,orient=HORIZONTAL)
        self.RedSlide.grid(row=3, column=1)
        self.RedSlide.set(0.0)
        self.GreenLabel = Label(self.ButtonFrame,text="Green").grid(row=4, column=0)
        self.GreenSlide = Scale(self.ButtonFrame, from_= 0.0, to=255.0,orient=HORIZONTAL)
        self.GreenSlide.grid(row=4, column=1)
        self.GreenSlide.set(0.0)
        self.BlueLabel = Label(self.ButtonFrame,text="Blue").grid(row=5, column=0)
        self.BlueSlide = Scale(self.ButtonFrame, from_= 0.0, to=255.0,orient=HORIZONTAL)
        self.BlueSlide.grid(row=5, column=1)
        self.BlueSlide.set(0.0)

        # Lists
        self.ListScroll = Scrollbar(self.ListFrame, orient=VERTICAL)
        self.ListScroll.grid( row=6, column=0,sticky=N+S+E,padx=20)
        self.List = Listbox(self.ListFrame, height=15, selectmode=MULTIPLE,yscrollcommand = self.ListScroll.set)
        self.List.grid( row=6, column=1,columnspan=3)

        # Fill the MatList with mat names; fill the Actor list in parallel;
        # the actual listbox gets a compound string showing the figure, actor, and matl.
        LS = ""
        # First list parts of figures, because the Mats really go with the figure,
        # not with the Actor.  This requires some sorting.
        for OneFig in scene.Figures():
            FigName = OneFig.Name()
            try:
                for OneMat in OneFigure.Materials():
                    MatName = OneMat.Name()
                    # Add the Figure to ListToMemorize, and the Mat itself
                    # to MatList.  Skip Previews, since they're dummies for
                    # this purpose.
                    if string.upper(MatName) != 'PREVIEW':
                        MatList.append(OneMat)
                        ListToMemorize.append(OneFigure)
                        LS = FigName + " : " + MatName
                        self.List.insert(END,LS)
            except: # Figure may not have materials.
                pass
        # Now look for Actors outside of a figure.  The IsProp
        # check eliminates internal stuff like the "NullMatSphere"
        for OneActor in scene.Actors():
            if OneActor.IsProp() and not OneActor.ItsFigure():
                try:
                    for OneMat in OneActor.Materials():
                        MatName = OneMat.Name()
                        if string.upper(MatName) != 'PREVIEW':
                            ActorName = OneActor.Name()
                            # Add the actor to ListToMemorize, and the Mat itself
                            # to MatList.
                            MatList.append(OneMat)
                            ListToMemorize.append(OneActor)
                            LS = ActorName + " : " + MatName
                            self.List.insert(END,LS)
                except: # Actor may not have materaisl.
                    pass


        # Go/nogo buttons.
        self.buttonGo = Button(self.master, text="Apply to All", command=self.HandleAll)
        self.buttonGo.grid(row=7, column=0)

        self.buttonSelected = Button(self.master, text="Apply to Selected", command=self.HandleSelected)
        self.buttonSelected.grid(row=7, column=1)

        self.buttonCancel = Button(self.master, text="Cancel", command=self.HandleCancel)
        self.buttonCancel.grid(row=7, column=2)

        # Bindings
        self.RedSlide.bind(sequence='<ButtonRelease-1>',func=self.FillGlobals)
        self.BlueSlide.bind(sequence='<ButtonRelease-1>',func=self.FillGlobals)
        self.GreenSlide.bind(sequence='<ButtonRelease-1>',func=self.FillGlobals)

        self.ListScroll["command"] = self.List.yview

        self.master.protocol('WM_DELETE_WINDOW', self.HandleCancel)


    # - - - - - - - - - - - - - - - - - -

    def FillGlobals(self,event):
        global Red,Green,Blue
        global NoTex
        global NoTrans

        # Set the two-way globals from radiobuttons.
        NoTex      = self.NoTexVar.get()
        NoTrans    = self.NoTransVar.get()

        # set the Numerical globals from the sliders.
        try:
            R = self.RedSlide.get()
            Red = float(R) / 256.0
        except:
            Red = 0.0
        try:
            G = self.GreenSlide.get()
            Green = float(G) / 256.0
        except:
            Green = 0.0
        try:
            B = self.BlueSlide.get()
            Blue = float(B) / 256.0
        except:
            Blue = 0.0
        AllHex="#%.2x%.2x%.2x" % (R,G,B)
        self.ListFrame.config(bg=AllHex)

    # - - - - - - - - - - - - - - - - - -

    def HandleAll(self):
        # Apply to all
        self.FillGlobals(None)
        MainAction()

    # - - - - - - - - - - - - - - - - - -

    def HandleSelected(self):
        self.FillGlobals(None)

        # Replace the non-selected Mats with 0 so we can skip
        # them in MainAction.  Don't worry about the ListToMemorize;
        # it's not the controlling factor.
        if app.List.curselection(): # Act only if we have some sels
            for Index in range(len(MatList)):   # All lists have same indexes at this point.
                if not (app.List.selection_includes(Index)): # If this is not selected:
                    MatList[Index] = 0
            MainAction()
        else:  #If nothing selected, just do like Cancel.
            self.master.destroy()

    # - - - - - - - - - - - - - - - - - -

    def HandleCancel(self):
        self.master.destroy()

#------------------------------------------------------------
# Activate the loop
#------------------------------------------------------------

app = App(root, "")
root.mainloop()

#------------------------------------------------------------
# End TK loop.
#-----------------------------------------------------------------------------
